<?php
function getFullStats()
{
  if(!$this->dbo) return "Statystki nie s dostpne.";

  //Weryfikacja danych
  $ile = -1;
  if(isset($_GET['ile'])){
    $ile = intval($_GET['ile']);
    if($ile >= -1){
      if($ile == 0){
        //Czy zostay przekazane daty?
        if(isset($_GET['dataOd']) && isset($_GET['dataDo'])){
          //Czy daty odpowiadaj formatowi?
          if(!preg_match("/^[0-9]{8}$/", $_GET['dataOd']) ||
             !preg_match("/^[0-9]{8}$/", $_GET['dataDo'])){
            //Niezgodno formatu.
            $ile = -1;
          }
          else{
            //Odczytanie dat.
            $dataOd = $_GET['dataOd'];
            $dataDo = $_GET['dataDo'];
          }
        }
        //Brak dat przy zaznaczonej opcji zakresu.
        else{
          $ile = -1;
        }
      }
      else{
        //Ustalenie maksymalnej dopuszczalnej liczby dni.
        if($ile > 3660) $ile = 3660;
      }
    }
    //Parametr ile by nieprawidowy.
    else{
      $ile = -1;
    }
  }
  
  //Formowanie warunkw zapyta i nagwka tabeli.
  if($ile == 0){
    //Dodanie warunku dotyczcego dat.
    $cond = " WHERE Data >= '$dataOd' AND Data <= '$dataDo' ";
    $statsInfo = "Statystyki z okresu $dataOd do $dataDo.";
  }
  else if($ile > 0){
    //Dodanie warunku dotyczcego wybranego okresu.
    $cond = " WHERE Data > DATE_SUB(NOW(), INTERVAL $ile DAY) ";
    $statsInfo = "Statystyki z ostatnich $ile dni.";
  }
  else{
    //Dodanie pustego warunku.
    $cond = ' WHERE 1=1 ';
    $statsInfo = "Pene statystyki";
  }
  
  //Dalsza cz metody.
}
?>